<?php
require_once '/home/advanck/salaires/models/Database.php';
use Models\Database;

session_start();

if (!isset($_SESSION['user']['id'])) {
    header('Location: /salaires/views/auth/login.php');
    exit();
}

if (!isset($_GET['id'])) {
    die("ID de fiche manquant");
}

$payslip_id = intval($_GET['id']);
$pdo = Database::getInstance()->getConnection();

// 📄 1. Récupération de la fiche de paie
$stmt = $pdo->prepare("
    SELECT p.*, e.first_name, e.last_name, e.matricule
    FROM payslips p
    JOIN employees e ON p.employee_id = e.id
    WHERE p.id = ?
");
$stmt->execute([$payslip_id]);
$payslip = $stmt->fetch();

if (!$payslip) {
    die("Fiche introuvable.");
}

// 📄 2. Récupération des cotisations sociales enregistrées
$stmt = $pdo->prepare("SELECT * FROM payslip_social WHERE payslip_id = ?");
$stmt->execute([$payslip_id]);
$socials = $stmt->fetchAll();

// 📄 3. Récupération des abattements
$stmt = $pdo->prepare("SELECT label, amount FROM payslip_moderation WHERE payslip_id = ?");
$stmt->execute([$payslip_id]);
$abattements = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Fiche de paie : <?= $payslip['last_name'] . ' ' . $payslip['first_name'] ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <h2 class="mb-4">Fiche de paie : <?= htmlspecialchars($payslip['last_name'] . ' ' . $payslip['first_name']) ?></h2>
    <p><strong>Matricule :</strong> <?= $payslip['matricule'] ?></p>
    <p><strong>Période :</strong> <?= htmlspecialchars($payslip['period']) ?></p>

    <hr>
    <h4>Cotisations sociales</h4>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Intitulé</th>
                <th>Base</th>
                <th>Taux (%)</th>
                <th>Montant (€)</th>
            </tr>
        </thead>
        <tbody>
            <?php $total_cotisations = 0; ?>
            <?php foreach ($socials as $social): ?>
            <tr>
                <td><?= htmlspecialchars($social['label']) ?></td>
                <td><?= number_format($social['gross_base'], 2, ',', ' ') ?> €</td>
                <td><?= number_format($social['rate'], 2, ',', ' ') ?> %</td>
                <td><?= number_format($social['amount'], 2, ',', ' ') ?> €</td>
            </tr>
            <?php $total_cotisations += $social['amount']; ?>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr class="table-secondary">
                <th colspan="3">Total cotisations</th>
                <th><?= number_format($total_cotisations, 2, ',', ' ') ?> €</th>
            </tr>
        </tfoot>
    </table>

    <h4>Abattements fiscaux</h4>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Type</th>
                <th>Montant (€)</th>
            </tr>
        </thead>
        <tbody>
            <?php $total_abattements = 0; ?>
            <?php foreach ($abattements as $ab): ?>
                <tr>
                    <td><?= $ab['label'] ?></td>
                    <td><?= number_format($ab['amount'], 2, ',', ' ') ?></td>
                </tr>
                <?php $total_abattements += $ab['amount']; ?>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr class="table-secondary">
                <th>Total abattements</th>
                <th><?= number_format($total_abattements, 2, ',', ' ') ?> €</th>
            </tr>
        </tfoot>
    </table>

    <h4 class="mt-4">Résumé</h4>
    <ul class="list-group">
        <li class="list-group-item"><strong>Salaire brut :</strong> <?= number_format($payslip['gross_salary'], 2, ',', ' ') ?> €</li>
        <li class="list-group-item"><strong>Total cotisations :</strong> <?= number_format($payslip['social_charges'], 2, ',', ' ') ?> €</li>
        <li class="list-group-item"><strong>Net avant impôts :</strong> <?= number_format($payslip['net_salary'], 2, ',', ' ') ?> €</li>
        <li class="list-group-item"><strong>Abattements :</strong> <?= number_format($payslip['abattements'], 2, ',', ' ') ?> €</li>
        <li class="list-group-item"><strong>Salaire imposable :</strong> <?= number_format($payslip['imposable'], 2, ',', ' ') ?> €</li>
        <li class="list-group-item"><strong>Impôt :</strong> <?= number_format($payslip['impots'], 2, ',', ' ') ?> €</li>
        <li class="list-group-item"><strong>Net après impôts :</strong> <?= number_format($payslip['net_apres_impot'], 2, ',', ' ') ?> €</li>
        <li class="list-group-item"><strong>Autres + :</strong> <?= number_format($payslip['other_plus'], 2, ',', ' ') ?> €</li>
        <li class="list-group-item"><strong>Autres - :</strong> <?= number_format($payslip['other_minus'], 2, ',', ' ') ?> €</li>
        <li class="list-group-item list-group-item-success"><strong>Net à payer :</strong> <?= number_format($payslip['net_final'], 2, ',', ' ') ?> €</li>
    </ul>

    <a href="/payslips" class="btn btn-secondary mt-4">← Retour</a>
</div>

</body>
</html>