<?php

namespace Utils;

class MoisFrHelper
{
    private static $moisMap = [
        '01' => 'Janvier',
        '02' => 'Février',
        '03' => 'Mars',
        '04' => 'Avril',
        '05' => 'Mai',
        '06' => 'Juin',
        '07' => 'Juillet',
        '08' => 'Août',
        '09' => 'Septembre',
        '10' => 'Octobre',
        '11' => 'Novembre',
        '12' => 'Décembre',
    ];

    /**
     * Convertit un mois FR en SQL (YYYY-MM)
     * Exemple : Juillet 2025 => 2025-07
     */
    public static function frToSql(string $moisFr): string
    {
        [$moisTxt, $annee] = explode(' ', trim($moisFr));
        $moisNum = array_search(ucfirst($moisTxt), self::$moisMap);
        if (!$moisNum) {
            $moisNum = '01';
        }
        return sprintf('%s-%s', $annee, $moisNum);
    }

    /**
     * Convertit une date SQL en mois FR
     * Exemple : 2025-07 => Juillet 2025
     */
    public static function sqlToFr(string $sqlDate): string
    {
        [$annee, $mois] = explode('-', $sqlDate);
        $moisFr = self::$moisMap[$mois] ?? 'Janvier';
        return sprintf('%s %s', $moisFr, $annee);
    }
}