<?php
require 'models/Database.php';

function test_db_connection() {
    $config = [
        'host' => 'advanckadvgroup.mysql.db',
        'name' => 'advanckadvgroup',
        'user' => 'advanckadvgroup',
        'pass' => 'MyDataBas3',
        'port' => 3306
    ];

    echo "<h3>Test de connexion MySQL</h3>";
    echo "<p>Hôte: ".htmlspecialchars($config['host'])."</p>";
    
    try {
        // Test 1: Connexion basique
        $dsn = "mysql:host={$config['host']};port={$config['port']}";
        $pdo = new PDO($dsn, $config['user'], $config['pass']);
        echo "<p style='color:green'>✓ Connexion au serveur MySQL réussie</p>";
        
        // Test 2: Sélection de la base
        $pdo->exec("USE {$config['name']}");
        echo "<p style='color:green'>✓ Accès à la base '{$config['name']}' réussi</p>";
        
        // Test 3: Requête simple
        $stmt = $pdo->query("SHOW TABLES");
        $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
        echo "<p>Tables trouvées (".count($tables)."): ".implode(', ', $tables)."</p>";
        
    } catch (PDOException $e) {
        echo "<p style='color:red'>✗ Erreur ".$e->getCode().": ".htmlspecialchars($e->getMessage())."</p>";
        
        // Solutions suggérées selon le code d'erreur
        switch ($e->getCode()) {
            case 2002:
                echo "<p>Problème de connexion au serveur MySQL. Vérifiez:</p>"
                    ."<ul>"
                    ."<li>Le serveur MySQL est-il en cours d'exécution?</li>"
                    ."<li>Le nom d'hôte est-il correct?</li>"
                    ."<li>Le port 3306 est-il ouvert?</li>"
                    ."</ul>";
                break;
            case 1045:
                echo "<p>Identifiants incorrects. Vérifiez le nom d'utilisateur et le mot de passe.</p>";
                break;
            case 1049:
                echo "<p>La base de données '{$config['name']}' n'existe pas.</p>";
                break;
            default:
                echo "<p>Erreur inattendue. Consultez les logs MySQL.</p>";
        }
    }
}

test_db_connection();
?>