<div class="container mt-4">
    <h2><?= isset($sociales) ? 'Modifier' : 'Ajouter' ?> un avantage en nature</h2>
    <form method="POST" action="<?= isset($sociales) ? '/public/social-settings/update' : '/public/social-settings/store' ?>">
        <?php if (isset($sociales)): ?>
            <input type="hidden" name="id" value="<?= $sociales['id'] ?>">
        <?php endif; ?>

        <div class="mb-3">
            <label>Clé</label>
            <input type="text" id="keyname" name="keyname" class="form-control" value="<?= htmlspecialchars($sociales['keyname'] ?? '') ?>" required>
        </div>

        <div class="mb-3">
            <label>Libellé</label>
            <input type="text" id="label" name="label" class="form-control" value="<?= htmlspecialchars($sociales['label'] ?? '') ?>" required>
        </div>

        <div class="mb-3">
            <label>Taux (%)</label>
            <input type="number" step="0.01" id="rate" name="rate" class="form-control" value="<?= htmlspecialchars($sociales['rate'] ?? '') ?>" required>
        </div>

        <div class="mb-3">
            <label>Base (%)</label>
            <input type="number" step="0.01" id="gross_base" name="gross_base" class="form-control" value="<?= htmlspecialchars($sociales['gross_base'] ?? '') ?>" required>
        </div>

        <button type="submit" class="btn btn-primary"><?= isset($sociales) ? 'Mettre à jour' : 'Enregistrer' ?></button>
        <button type="cancel" class="btn btn-secondary">Annuler</button>
    </form>
</div>