<div class="container mt-4">
    <h2>Gestion des paramètres</h2>
    
    <?php if (isset($_SESSION['message'])): ?>
        <div class="alert alert-success"><?= $_SESSION['message']; unset($_SESSION['message']); ?></div>
    <?php endif; ?>

    <a href="/settings/create" class="btn btn-primary mb-3">Ajouter un paramètre</a>

    <?php if (!empty($settings)): ?>
    <table class="table table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Clé</th>
                <th>Libellé</th>
                <th>Valeur</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($settings as $setting): ?>
            <tr>
                <td><?= htmlspecialchars($setting['id']) ?></td>
                <td><?= htmlspecialchars($setting['keyname']) ?></td>
                <td><?= htmlspecialchars($setting['label']) ?></td>
                <td><?= htmlspecialchars($setting['value']) ?></td>
                <td>
                    <a href="/settings/edit?id=<?= $setting['id'] ?>" class="btn btn-sm btn-warning">Éditer</a>
                    <form action="/settings/delete?id=<?= $setting['id'] ?>" method="POST" style="display:inline;">
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Êtes-vous sûr ?')">Supprimer</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="alert alert-info">Aucun paramètre trouvé</div>
<?php endif; ?>
</div>