<div class="container mt-4">
    <h2>Modifier la fiche de paie</h2>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <form method="POST" action="/public/payslips/update">
        <input type="hidden" name="id" value="<?= htmlspecialchars($payslip['id']) ?>">

        <div class="mb-3">
            <label class="form-label">Employé</label>
            <input type="text" class="form-control" readonly
                   value="<?= htmlspecialchars($payslip['employee_id']) ?> - <?= htmlspecialchars($payslip['last_name']) ?> <?= htmlspecialchars($payslip['first_name']) ?>">
        </div>

        <div class="mb-3">
            <label class="form-label">Période</label>
            <input type="text" name="period" class="form-control" value="<?= htmlspecialchars($payslip['period']) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Salaire brut (€)</label>
            <input type="number" name="gross_salary" class="form-control" step="0.01"
                   value="<?= htmlspecialchars($payslip['gross_salary']) ?>" required>
        </div>

        <button type="submit" class="btn btn-primary">Mettre à jour</button>
        <a href="/payslips" class="btn btn-secondary">Annuler</a>
    </form>
</div>