<?php
// Activation du débogage
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require 'models/Database.php';

try {
    echo "<h2>Test de connexion à la base de données</h2>";
    
    // Utilisation correcte du Singleton
    $db = Database::getInstance();  // <- Modification clé ici
    $pdo = $db->getConnection();
    
    echo "<p style='color:green'>✓ Connexion réussie!</p>";
    
    // Test de requête
    $stmt = $pdo->query("SELECT 1 AS test_value, NOW() AS server_time");
    $result = $stmt->fetch();
    
    echo "<pre>Résultat de test: ";
    print_r($result);
    echo "</pre>";
    
    // Liste des tables
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    echo "<p>Tables disponibles (" . count($tables) . "):</p>";
    echo "<ul>";
    foreach ($tables as $table) {
        echo "<li>" . htmlspecialchars($table) . "</li>";
    }
    echo "</ul>";

} catch (Exception $e) {
    echo "<p style='color:red'>✗ Erreur: " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<h3>Détails techniques</h3>";
    echo "<pre>";
    debug_print_backtrace();
    echo "</pre>";
}
?>