<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../models/Database.php';
use Models\Database;

header('Content-Type: application/json');

try {
    $pdo = Database::getInstance()->getConnection();
    $employee_id = isset($_GET['employee_id']) ? intval($_GET['employee_id']) : 0;

    if (!$employee_id) {
        echo json_encode([]);
        exit;
    }

    $stmt = $pdo->prepare("SELECT keyname, label, amount FROM benefits_in_kind_settings WHERE employee_id = ?");
    $stmt->execute([$employee_id]);
    echo json_encode($stmt->fetchAll());

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
