<?php
require_once __DIR__.'/../../models/Database.php';
use Models\Database;

header('Content-Type: application/json');

$pdo = Database::getInstance()->getConnection();
$employee_id = intval($_GET['employee_id'] ?? 0);

if ($employee_id > 0) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM payslips WHERE employee_id = ? AND validated = 0");
    $stmt->execute([$employee_id]);
    $count = $stmt->fetchColumn();

    echo json_encode(['has_unvalidated' => ($count > 0)]);
} else {
    echo json_encode(['has_unvalidated' => false]);
}