<?php
require_once 'Database.php';

class SocialSetting {
    private $db;

    public function __construct() {
        $this->db = (new Database())->connect();
    }

    public function findAll() {
        $stmt = $this->db->prepare("SELECT * FROM social_settings");
        $stmt->execute();
        
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $settings = [];
        
        foreach ($results as $row) {
            $settings[$row['keyname']] = $row;
        }
        
        return $settings;
    }

    public function updateAll($settings) {
        $this->db->beginTransaction();
        
        try {
            foreach ($settings as $key => $values) {
                $stmt = $this->db->prepare("
                    UPDATE social_settings 
                    SET rate = :rate, gross_base = :gross_base 
                    WHERE keyname = :keyname
                ");
                
                $stmt->bindParam(':rate', $values['rate'], PDO::PARAM_STR);
                $stmt->bindParam(':gross_base', $values['gross_base'], PDO::PARAM_STR);
                $stmt->bindParam(':keyname', $key, PDO::PARAM_STR);
                $stmt->execute();
            }
            
            $this->db->commit();
            return true;
        } catch (PDOException $e) {
            $this->db->rollBack();
            error_log("Error updating social settings: " . $e->getMessage());
            return false;
        }
    }
}
?>