<?php
namespace Models;
require_once __DIR__ . '/../models/Database.php';
use PDO;

class ModerationSettings {

    private static $pdo;

    // Initialiser la connexion à la base de données
    public static function init() {
        if (self::$pdo == null) {
            self::$pdo = Database::getInstance()->getConnection();
            self::$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        }
    }

    // Récupérer tous les abattements
    public static function getAll() {
        self::init();
        $stmt = self::$pdo->query("SELECT * FROM moderation_settings");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Ajouter un abattement
    public static function add($employee_id, $keyname, $label, $amount) {
        self::init();
        $stmt = self::$pdo->prepare("INSERT INTO moderation_settings (employee_id, keyname, label, amount) VALUES (?, ?, ?, ?)");
        $stmt->execute([$employee_id, $keyname, $label, $amount]);
    }

    // Mettre à jour un abattement
    public static function update($id, $employee_id, $keyname, $label, $amount) {
        self::init();
        $stmt = self::$pdo->prepare("UPDATE moderation_settings SET employee_id = ?, keyname = ?, label = ?, amount = ? WHERE id = ?");
        $stmt->execute([$employee_id, $keyname, $label, $amount, $id]);
    }

    // Supprimer un abattement
    public static function delete($id) {
        self::init();
        $stmt = self::$pdo->prepare("DELETE FROM moderation_settings WHERE id = ?");
        $stmt->execute([$id]);
    }
}
?>