<?php
// Activation des sessions
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Configuration de base
declare(strict_types=1);
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

// Autoloader
spl_autoload_register(function ($class) {
    // Mapping explicite namespace => dossier
    $namespace_map = [
        'Controllers\\' => 'controllers/',
        'Utils\\' => 'utils/',
        'Models\\' => 'models/'
    ];
    
    foreach ($namespace_map as $prefix => $base_dir) {
        // Vérifie si la classe utilise ce namespace
        if (strpos($class, $prefix) === 0) {
            // Construit le chemin du fichier
            $relative_class = substr($class, strlen($prefix));
            $file = __DIR__.'/../'.$base_dir.str_replace('\\', '/', $relative_class).'.php';
            
            // Debug: Enregistre les tentatives de chargement
            error_log("Tentative de chargement: $file");
            
            if (is_file($file)) {
                require $file;
                return;
            }
        }
    }
    
    throw new RuntimeException("Échec du chargement de la classe $class");
});