<?php
require_once __DIR__ . '/../../models/Database.php';
use Models\Database;
// Utilisation de PDO pour la connexion à la base de données
$pdo = Database::getInstance()->getConnection();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Gérer l'ajout d'un nouvel abattement
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add'])) {
    $employee_id = $_POST['employee_id'];
    $keyname = $_POST['keyname'];
    $value = $_POST['value'];
    $amount = $_POST['amount'];

    $stmt = $pdo->prepare("INSERT INTO moderation_settings (employee_id, keyname, value, amount) VALUES (?, ?, ?, ?)");
    $stmt->execute([$employee_id, $keyname, $value, $amount]);
    header('Location: moderation-settings');  // Redirection pour afficher les changements
    exit;
}

// Gérer la mise à jour d'un abattement
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update'])) {
    $id = $_POST['id'];
    $employee_id = $_POST['employee_id'];
    $keyname = $_POST['keyname'];
    $value = $_POST['value'];
    $amount = $_POST['amount'];

    $stmt = $pdo->prepare("UPDATE moderation_settings SET employee_id = ?, keyname = ?, value = ?, amount = ? WHERE id = ?");
    $stmt->execute([$employee_id, $keyname, $value, $amount, $id]);
    header('Location: moderation-settings');
    exit;
}

// Gérer la suppression d'un abattement
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete'])) {
    $id = $_POST['id'];
    $stmt = $pdo->prepare("DELETE FROM moderation_settings WHERE id = ?");
    $stmt->execute([$id]);
    header('Location: moderation-settings');
    exit;
}

// Récupérer tous les abattements
$stmt = $pdo->query("SELECT * FROM moderation_settings");
$moderation_settings = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Employés actifs
$employees = $pdo->query("SELECT id, first_name, last_name FROM employees WHERE status = 'actif' ORDER BY last_name")->fetchAll();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestion des Abattements</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f7fc;
            margin: 0;
            padding: 0;
            color: #333;
        }

        .container {
            max-width: 900px;
            margin: 20px auto;
            background-color: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
            color: #3b3f50;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
        }

        .form-group input {
            width: 100%;
            padding: 12px;
            font-size: 16px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }

        .form-group button {
            background-color: #007bff;
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            width: 100%;
            text-align: center;
        }

        .form-group button:hover {
            background-color: #0056b3;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 30px;
        }

        table th, table td {
            padding: 12px;
            text-align: left;
            border: 1px solid #ddd;
        }

        table th {
            background-color: #007bff;
            color: white;
        }

        .action-buttons button {
            background-color: #28a745;
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            margin-right: 8px;
        }

        .action-buttons button.delete {
            background-color: #dc3545;
        }

        .action-buttons button:hover {
            opacity: 0.8;
        }
    </style>
</head>
<body>

<div class="container">
    <h1>Gestion des Abattements</h1>

    <!-- Formulaire pour ajouter un nouvel abattement -->
    <h2>Ajouter un Abattement</h2>
    <form method="POST">
        <div class="mb-3">
            <label>Employé</label>
            <select name="employee_id" id="employee_id" class="form-select" required>
                <option value="">-- Sélectionner --</option>
                <?php foreach ($employees as $emp): ?>
                    <option value="<?= $emp['id'] ?>">
                        <?= htmlspecialchars($emp['last_name'] . ' ' . $emp['first_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="keyname">Nom du Paramètre :</label>
            <input type="text" name="keyname" required>
        </div>

        <div class="form-group">
            <label for="value">Valeur :</label>
            <input type="text" name="value" required>
        </div>

        <div class="form-group">
            <label for="amount">Montant :</label>
            <input type="number" name="amount" step="0.01" required>
        </div>

        <button class="btn btn-success" type="submit" name="add">Ajouter</button>
    </form>

    <!-- Table pour afficher les abattements existants -->
    <h2>Abattements Actuels</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>ID Employé</th>
                <th>Nom du Paramètre</th>
                <th>Valeur</th>
                <th>Montant</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($moderation_settings as $setting): ?>
                <tr>
                    <form method="POST">
                        <td><?php echo $setting['id']; ?></td>
                        <td><input type="number" name="employee_id" value="<?php echo $setting['employee_id']; ?>" required></td>
                        <td><input type="text" name="keyname" value="<?php echo $setting['keyname']; ?>" required></td>
                        <td><input type="text" name="value" value="<?php echo $setting['value']; ?>" required></td>
                        <td><input type="number" name="amount" step="0.01" value="<?php echo $setting['amount']; ?>" required></td>
                        <td class="action-buttons">
                            <button type="submit" name="update" value="<?php echo $setting['id']; ?>">Enregistrer</button>
                            <button type="submit" name="delete" value="<?php echo $setting['id']; ?>" class="delete">Supprimer</button>
                        </td>
                        <td><input type="number" name="id" value="<?php echo $setting['id']; ?>" hidden></td>
                    </form>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

</div>

</body>
</html>
