<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h2 class="mb-0">Tableau de bord</h2>
                </div>
                <div class="card-body">
                    <?php use Utils\Auth; ?>
                    <?php if (Auth::isLoggedIn()): ?>
                        <!-- Contenu pour utilisateur connecté -->
                        <div class="alert alert-success">
                            <h4>Bienvenue, <?= htmlspecialchars($_SESSION['user']['username']) ?> !</h4>
                            <p class="mb-0">Email : <?= htmlspecialchars($_SESSION['user']['email']) ?></p>
                        </div>
                        
                        <div class="d-grid gap-3">
                            <a href="/public/employees" class="btn btn-primary btn-lg">
                                Gestion des employés
                            </a>
                            <a href="/public/payslips" class="btn btn-secondary btn-lg">
                                Gestion des fiches de paie
                            </a>
                        </div>

                    <?php else: ?>
                        <!-- Contenu pour visiteur non connecté -->
                        <div class="alert alert-info">
                            <h4 class="alert-heading">Bienvenue sur ADVANCED Payroll</h4>
                            <p>Veuillez vous connecter pour accéder au système.</p>
                            <hr>
                            <div class="d-flex justify-content-center">
                                <a href="/public/login" class="btn btn-primary px-5">
                                    <i class="bi bi-box-arrow-in-right"></i> Connexion
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
                <div class="card-footer text-muted">
                    <small>Dernière connexion : 
                        <?= isset($_SESSION['user']['last_login']) 
                            ? date('d/m/Y H:i', strtotime($_SESSION['user']['last_login'])) 
                            : 'Nouvel utilisateur' ?>
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>