<!-- /home/advanck/salaires/views/errors/404.php -->
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Page introuvable - ADVANCED Payroll</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            color: #343a40;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            text-align: center;
        }
        .error-container {
            max-width: 600px;
            margin: 50px auto;
            padding: 30px;
            background: white;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #dc3545;
            font-size: 2.5em;
        }
        a {
            color: #007bff;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <h1>404</h1>
        <p>Désolé, la page que vous recherchez est introuvable.</p>
        <p><a href="/views/dashboard">Retour à l'accueil</a></p>
        
        <?php if (isset($_SERVER['DEBUG_MODE']) && $_SERVER['DEBUG_MODE'] === 'true'): ?>
            <div style="margin-top: 20px; text-align: left; font-size: 0.9em; color: #6c757d;">
                <p><strong>Détails techniques :</strong></p>
                <p>URL demandée : <?= htmlspecialchars($_SERVER['REQUEST_URI']) ?></p>
                <p>Contrôleur recherché : <?= htmlspecialchars($controllerName ?? 'N/A') ?></p>
                <p>Méthode : <?= htmlspecialchars($methodName ?? 'N/A') ?></p>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>