<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '/../../models/Database.php';
use Models\Database;

session_start();

if (!isset($_SESSION['user']['id']) || !isset($_GET['id'])) {
    header('Location: /../views/auth/login.php');
    exit();
}

$pdo = Database::getInstance()->getConnection();
$id = intval($_GET['id']);

// (optionnel) vérification que l'employé existe
$stmt = $pdo->prepare("SELECT * FROM employees WHERE id = ?");
$stmt->execute([$id]);
$emp = $stmt->fetch();

if (!$emp) {
    echo "Employé introuvable.";
    exit();
}

// Suppression
if ($_SESSION['user']['user_roles'] !== 'admin') {
    die("Accès interdit : seuls les administrateurs peuvent supprimer un employé.");
}
$stmt = $pdo->prepare("DELETE FROM employees WHERE id = ?");
$stmt->execute([$id]);

header('Location: /employees/view');
exit();
