<?php
$hash = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['password'])) {
    $password = $_POST['password'];
    $hash = password_hash($password, PASSWORD_BCRYPT);
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Générateur de Hash BCRYPT</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <h2 class="mb-4">🔐 Générer un hash BCRYPT</h2>
    <form method="POST" class="card p-4 shadow-sm bg-white">
        <div class="mb-3">
            <label for="password" class="form-label">Mot de passe à hasher :</label>
            <input type="text" name="password" id="password" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-primary">Générer le hash</button>
    </form>

    <?php if (!empty($hash)) : ?>
        <div class="alert alert-success mt-4">
            <strong>Hash généré :</strong><br>
            <code><?= htmlspecialchars($hash) ?></code>
        </div>
    <?php endif; ?>
</div>
</body>
</html>