<?php
namespace Controllers;

class HomeController
{
    public function index() {
    try {
        $this->render('home/index', [
            'title' => 'Page d\'accueil'
        ]);
    } catch (\Exception $e) {
        die("Erreur vue: " . $e->getMessage());
    }
}

   protected function render(string $viewPath, array $data = []) {
        $viewFile = __DIR__.'/../views/'.$viewPath.'.php';
        
        if (!file_exists($viewFile)) {
            throw new \RuntimeException("Vue introuvable: $viewPath (Chemin: $viewFile)");
        }

        extract($data);
        require $viewFile;
    }
}