<?php
require_once '/home/advanck/salaires/models/Database.php';
use Models\Database;

session_start();
if (!isset($_SESSION['user']['id']) || !isset($_GET['id'])) {
    header('Location: /salaires/views/auth/login.php');
    exit();
}

$pdo = Database::getInstance()->getConnection();
$id = intval($_GET['id']);

// Récupération de la fiche à dupliquer
$stmt = $pdo->prepare("SELECT * FROM payslips WHERE id = ?");
$stmt->execute([$id]);
$p = $stmt->fetch();

if (!$p) {
    die("Fiche introuvable.");
}

// Si formulaire soumis
$message = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['period'])) {
    // Formatage mois français
    $moisFr = [
        '01' => 'janvier', '02' => 'février', '03' => 'mars', '04' => 'avril',
        '05' => 'mai', '06' => 'juin', '07' => 'juillet', '08' => 'août',
        '09' => 'septembre', '10' => 'octobre', '11' => 'novembre', '12' => 'décembre'
    ];
    list($annee, $mois) = explode('-', $_POST['period']);
    $period = $moisFr[$mois] . ' ' . $annee;

    // Vérifie si une fiche existe déjà
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM payslips WHERE employee_id = ? AND period = ?");
    $stmt->execute([$p['employee_id'], $period]);
    $exists = $stmt->fetchColumn();

    if ($exists > 0) {
        $message = "⚠ Une fiche existe déjà pour cette période.";
    } else {
        // Insertion
        $stmt = $pdo->prepare("
            INSERT INTO payslips (employee_id, period, gross_salary, net_salary, social_charges, abattements, tax, other_plus, other_minus)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([
            $p['employee_id'],
            $period,
            $p['gross_salary'],
            $p['net_salary'],
            $p['social_charges'],
            $p['abattements'],
            $p['tax'],
            $p['other_plus'],
            $p['other_minus']
        ]);
        header('Location: /payslips/success');
        exit();
    }
}

?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Dupliquer une fiche</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <h2>Dupliquer une fiche de paie</h2>
    <?php if ($message): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>
    <p>Employé ID #<?= $p['employee_id'] ?> – Salaire brut : <?= number_format($p['gross_salary'], 2, ',', ' ') ?> €</p>

    <form method="POST" class="mt-4">
        <div class="mb-3">
            <label for="period" class="form-label">Nouvelle période</label>
            <input type="month" name="period" id="period" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-warning">📄 Dupliquer la fiche</button>
        <a href="index.php" class="btn btn-secondary">Annuler</a>
    </form>
</div>

</body>
</html>
