<?php
session_start(); // Démarre la session
/**
 * Dashboard - Tableau de bord principal
 * 
 * @var array $employees Liste des employés
 * @var int $employeeCount Nombre total d'employés
 * @var int $payslipCount Nombre de fiches ce mois
 * @var string $lastActivity Dernière activité formatée
 * @var array $recentActivities Activités récentes
 */

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tableau de bord | ADVANCED Payroll</title>
    
    <!-- CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://salaires.advancedgroup.lu/assets/css/dashboard.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
</head>
<body>
    <!-- Menu Mobile -->
    <button class="d-lg-none btn btn-primary position-fixed" 
            style="bottom:20px; right:20px; z-index:1050;"
            id="mobileMenuToggle">
        <i class="bi bi-list"></i>
    </button>

    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-lg-2 sidebar" id="sidebar">
                <div class="position-sticky pt-3">
                    <div class="text-center mb-4">
                        <h4 class="text-white">ADVANCED Payroll</h4>
                    </div>
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" href="/public/dashboard">
                                <i class="bi bi-speedometer2 me-2"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item" onclick="toggleSubmenu(this)" style="cursor:context-menu;">
                                <i class="bi bi-people-fill me-2 nav-link">  Employés</i>
                        </li>
                        <ul class="submenu">
                            <li><a href="/employees">Tableau de bord</a></li>
                            <li><a href="/employees/view">Voir</a></li>
                            <li><a href="/employees/create">Ajouter</a></li>
                        </ul>
                        <li class="nav-item" onclick="toggleSubmenu(this)" style="cursor:context-menu;">
                                <i class="bi bi-file-earmark-text me-2 nav-link"> Fiches de paie</i>
                        </li>
                        <ul class="submenu">
                            <li><a href="/payslips">Voir</a></li>
                            <li><a href="/payslips/create">Ajouter</a></li>
                        </ul>
                        <?php if ($_SESSION['user']['role'] === 'admin'): ?>
                        <li class="nav-item" onclick="toggleSubmenu(this)" style="cursor:context-menu;">
                            <i class="bi bi-shield-lock me-2 nav-link"> Administration</i></li>
                        <ul class="submenu">
                            <li><a href="/social-settings">Paramètres Sociaux</a></li>
                            <li><a href="/moderation-settings">Abattements</a></li>
                            <li><a href="/benefits">Gérer les avantages en nature</a></li>
                            <li><a class="dropdown-item" href="/settings">Paramètres généraux</a></li>
                        </ul>
                        <?php endif; ?>
                    </ul>
                </div>
            </nav>

            <!-- Main Content -->
            <main class="col-lg-8 main-content px-4 py-3">
                <?php if(isset($view)): include $view; ?>
                <? else: ?>
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Tableau de bord</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <button class="btn btn-sm btn-outline-secondary">
                                <i class="bi bi-calendar3"></i> <?= date('F Y') ?>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- KPI Cards -->
                <div class="row mb-4">
                    <div class="col-md-4">
                        <div class="card text-white bg-primary kpi-card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="card-title">Employés</h5>
                                        <h2 class="mb-0"><?= $employeeCount ?></h2>
                                    </div>
                                    <i class="bi bi-people-fill display-4 opacity-50"></i>
                                </div>
                                <a href="/public/employees" class="text-white stretched-link"></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card text-white bg-success kpi-card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="card-title">Paies ce mois</h5>
                                        <h2 class="mb-0"><?= $payslipCount ?></h2>
                                    </div>
                                    <i class="bi bi-cash-stack display-4 opacity-50"></i>
                                </div>
                                <a href="/public/payslips" class="text-white stretched-link"></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card text-white bg-info kpi-card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="card-title">Dernière activité</h5>
                                        <p class="mb-0"><?= $lastActivity ?></p>
                                    </div>
                                    <i class="bi bi-activity display-4 opacity-50"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Graphiques -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="card shadow">
                            <div class="card-header">
                                <h5>Répartition des départements</h5>
                            </div>
                            <div class="card-body">
                                <canvas id="departmentChart" height="250"></canvas>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card shadow">
                            <div class="card-header">
                                <h5>Fiches de paie mensuelles</h5>
                            </div>
                            <div class="card-body">
                                <canvas id="payslipChart" height="250"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Activité récente -->
                <div class="card shadow">
                    <div class="card-header">
                        <h5>Activité récente</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Action</th>
                                        <th>Utilisateur</th>
                                        <th>Détails</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recentActivities as $activity): ?>
                                    <tr>
                                        <td><?= date('d/m/Y H:i', strtotime($activity['date'])) ?></td>
                                        <td><?= htmlspecialchars($activity['action']) ?></td>
                                        <td><?= htmlspecialchars($activity['user']) ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary" 
                                                    data-bs-toggle="tooltip" 
                                                    title="<?= htmlspecialchars($activity['details']) ?>">
                                                <i class="bi bi-info-circle"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <? endif; ?>
            </main>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // Menu mobile
        document.getElementById('mobileMenuToggle').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('active');
        });

        // Graphiques
        document.addEventListener('DOMContentLoaded', function() {
            // Répartition départements
            new Chart(document.getElementById('departmentChart'), {
                type: 'doughnut',
                data: {
                    labels: ['Comptabilité', 'RH', 'IT', 'Direction', 'Production'],
                    datasets: [{
                        data: [12, 8, 5, 3, 22],
                        backgroundColor: [
                            '#3498db', '#2ecc71', '#f1c40f', '#e74c3c', '#9b59b6'
                        ]
                    }]
                }
            });

            // Fiches de paie mensuelles
            new Chart(document.getElementById('payslipChart'), {
                type: 'bar',
                data: {
                    labels: ['Jan', 'Fév', 'Mar', 'Avr', 'Mai', 'Jun'],
                    datasets: [{
                        label: 'Fiches générées',
                        data: [120, 190, 150, 240, 220, 180],
                        backgroundColor: 'rgba(52, 152, 219, 0.7)'
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });

            // Activer les tooltips Bootstrap
            [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]')).forEach(function (el) {
                new bootstrap.Tooltip(el);
            });
        });
    </script>
    
    <script>
    // Fonction pour afficher/masquer les sous-menus
    function toggleSubmenu(element) {
        // Vérifie si le sous-menu est déjà visible
        var submenu = element.nextElementSibling;
        
        if (submenu.style.display === "block") {
            submenu.style.display = "none"; // Masquer le sous-menu
        } else {
            submenu.style.display = "block"; // Afficher le sous-menu
        }
        
        // Toggle la classe "active" sur le menu
        element.classList.toggle("active");
    }
</script>
    <!-- jQuery d'abord -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="/assets/js/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/js/datatables/dataTables.bootstrap4.min.js"></script>
    <div id="toast-container" class="toast-container position-fixed bottom-0 end-0 p-3"></div>

    <script src="/public/assets/js/settings.js"></script>
</body>
</html>