<?php
namespace Models;
require_once __DIR__ . '/../models/Database.php';
use PDO;

class SocialSettings {
    private static $pdo;

// Initialiser la connexion à la base de données
    public static function init() {
        if (self::$pdo == null) {
            self::$pdo = Database::getInstance()->getConnection();
            self::$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        }
    }
    // Récupérer tous les paramètres sociaux
    public static function getAllSettings() {
        self::init();
        $stmt = self::$pdo->query("SELECT * FROM social_settings");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Ajouter un paramètre social
    public static function addSetting($keyname, $label, $rate, $gross_base) {
        self::init();
        $stmt = self::$pdo->prepare("INSERT INTO social_settings (keyname, label, rate, gross_base) VALUES (?, ?, ?, ?)");
        $stmt->execute([$keyname, $label, $rate, $gross_base]);
    }

    // Mettre à jour un paramètre social
    public static function updateSetting($id, $keyname, $label, $rate, $gross_base) {
        self::init();
        $stmt = self::$pdo->prepare("UPDATE social_settings SET keyname = ?, label = ?, rate = ?, gross_base = ? WHERE id = ?");
        $stmt->execute([$keyname, $label, $rate, $gross_base, $id]);
    }

    // Supprimer un paramètre social
    public static function deleteSetting($id) {
        self::init();
        $stmt = self::$pdo->prepare("DELETE FROM social_settings WHERE id = ?");
        $stmt->execute([$id]);
    }

    public function findAll() {
        $stmt = $this->conn->prepare("SELECT * FROM social_settings");
        $stmt->execute();
        
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $settings = [];
        
        foreach ($results as $row) {
            $settings[$row['keyname']] = $row;
        }
        
        return $settings;
    }
}
?>