<?php
namespace Models;
//require_once __DIR__ . '/../models/Database.php';
require_once '/home/advanck/salaires/models/Database.php';
use PDO;

class Employee {
    private static $pdo;

// Initialiser la connexion à la base de données
    public static function init() {
        if (self::$pdo == null) {
            self::$pdo = Database::getInstance()->getConnection();
            self::$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        }
    }
    // Récupérer tous les employés
    public static function getAll() {
        self::init();
        $stmt = self::$pdo->query("SELECT * FROM employees");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Ajouter un nouvel employé
    public static function add($first_name, $last_name, $contract_start, $matricule, $date_entree, $taux_impot, $indice, $statut_fiscal, $profession, $heures_semaine, $heures_mois, $iban, $bic_code, $bank, $status) {
        self::init();
        $stmt = self::$pdo->prepare("INSERT INTO employees (first_name, last_name, contract_start, matricule, date_entree, taux_impot, indice, statut_fiscal, profession, heures_semaine, heures_mois, iban, bic_code, bank, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$first_name, $last_name, $contract_start, $matricule, $date_entree, $taux_impot, $indice, $statut_fiscal, $profession, $heures_semaine, $heures_mois, $iban, $bic_code, $bank, $status]);
    }

    // Mettre à jour un employé
    public static function update($id, $first_name, $last_name, $contract_start, $contract_end, $matricule, $date_entree, $taux_impot, $indice, $date_sortie, $date_anciennete, $statut_fiscal, $profession, $heures_semaine, $heures_mois, $iban, $bic_code, $bank, $status) {
        self::init();
        $stmt = self::$pdo->prepare("UPDATE employees SET first_name = ?, last_name = ?, contract_start = ?, contract_end = ?, matricule = ?, date_entree = ?, taux_impot = ?, indice = ?, date_sortie = ?, date_anciennete = ?, statut_fiscal = ?, profession = ?, heures_semaine = ?, heures_mois = ?, iban = ?, bic_code = ?, bank = ?, status = ? WHERE id = ?");
        $stmt->execute([$first_name, $last_name, $contract_start, $contract_end, $matricule, $date_entree, $taux_impot, $indice, $date_sortie, $date_anciennete, $statut_fiscal, $profession, $heures_semaine, $heures_mois, $iban, $bic_code, $bank, $status, $id]);
    }

    // Supprimer un employé
    public static function delete($id) {
        self::init();
        $stmt = self::$pdo->prepare("DELETE FROM employees WHERE id = ?");
        $stmt->execute([$id]);
    }

    // Récupérer un employé par ID
    public static function getById($id) {
        self::init();
        $stmt = self::$pdo->prepare("SELECT * FROM employees WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    // Récupérer le nombre d'employés actifs
    public function count(): int {
        self::init();
        $stmt = self::$pdo->prepare("SELECT COUNT(*) FROM employees WHERE status = 'actif'");
        $stmt->execute();
        return $stmt->fetchColumn();
    }
    // Récupérer le nombre d'employés par status 
    public function statusCount() {
        self::init();
        $stmt = self::$pdo->query("SELECT status, COUNT(*) as count FROM employees GROUP BY status");
        $status_counts = ['actif' => 0, 'inactif' => 0];
        while ($row = $stmt->fetch()) {
            $status_counts[$row['status']] = $row['count'];
        }
        return  $status_counts;
    }
    // Récupération des employés
    public function viewAllEmployees(){
        self::init();
        $stmt = self::$pdo->query("SELECT * FROM employees ORDER BY last_name, first_name");
        $employees = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $employees;
    }
}
?>