<?php
namespace Controllers;
require_once __DIR__ . '/../models/ModerationSettings.php';
use Models\ModerationSettings;
use Utils\Auth;

class ModerationController {
    public function index() {
        // Afficher la liste des abattements
        Auth::checkPermission(['admin', 'chef_comptable']);
        // Récupérer tous les abattements via le modèle
        $moderationSettings = ModerationSettings::getAll();
        $this->loadInDashboard('moderation.php', $moderationSettings);
    }
    private function loadInDashboard($viewFile, $data = []) {
        extract($data);
        $viewPath = __DIR__ . '/../views/settings/' . $viewFile;

        if (!file_exists($viewPath)) {
            throw new \Exception("Vue $viewFile introuvable");
        }

        $view = $viewPath;
        require __DIR__ . '/../views/dashboard.php';
    }

    // Ajouter un nouvel abattement
    public function add() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add'])) {
            // Récupérer les données soumises
            $employee_id = $_POST['employee_id'];
            $keyname = $_POST['keyname'];
            $label = $_POST['label'];
            $amount = $_POST['amount'];

            // Appeler la méthode du modèle pour ajouter l'abattement
            ModerationSettings::add($employee_id, $keyname, $label, $amount);
            header('Location: /moderation');  // Redirection vers la liste des abattements
            exit;
        }
    }

    // Mettre à jour un abattement
    public function update() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update'])) {
            // Récupérer les données du formulaire
            $id = $_POST['id'];
            $employee_id = $_POST['employee_id'];
            $keyname = $_POST['keyname'];
            $label = $_POST['label'];
            $amount = $_POST['amount'];

            // Appeler la méthode du modèle pour mettre à jour l'abattement
            ModerationSettings::update($id, $employee_id, $keyname, $label, $amount);
            header('Location: /moderation');  // Redirection vers la liste des abattements
            exit;
        }
    }

    // Supprimer un abattement
    public function delete() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete'])) {
            $id = $_POST['id'];

            // Appeler la méthode du modèle pour supprimer l'abattement
            ModerationSettings::delete($id);
            header('Location: /moderation');  // Redirection vers la liste des abattements
            exit;
        }
    }

    // Supprimer un abattement
    public function testme() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete'])) {
            $id = $_POST['id'];

            // Appeler la méthode du modèle pour supprimer l'abattement
            
            header('Location: /utils/get_abattements.php?employee_id=1');  // Redirection vers la liste des abattements
            exit;
        }
    }
}
?>
