<?php
session_start();
/* require_once __DIR__ . '/../../utils/Helpers.php';
use Utils\Helpers; */

if (!isset($_SESSION['user']['id'])) {
    header('Location: login');
    exit();
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Tableau de bord - ADVANCED</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Chart.js CDN -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
<?php //include 'includes/navbar.php'; ?>

<div class="container mt-4">
    <h1 class="mb-4">Tableau de bord</h1>

    <div class="row g-4">
        <div class="col-md-4">
           <div class="card text-white bg-primary kpi-card">
             <div class="card-body">
                 <div class="d-flex justify-content-between align-items-center">
                     <div>
                         <h5 class="card-title">Employés</h5>
                         <h2 class="mb-0"><?= $status_counts['actif'] ?></h2>
                     </div>
                     <i class="bi bi-people-fill display-4 opacity-50"></i>
                 </div>
                 <a href="/public/employees/view" class="text-white stretched-link"></a>
             </div>
           </div>
        </div>
        <div class="col-md-4">
           <div class="card text-white bg-secondary kpi-card">
             <div class="card-body">
                 <div class="d-flex justify-content-between align-items-center">
                     <div>
                         <h5 class="card-title">Employés inactifs</h5>
                         <h2 class="mb-0"><?= $status_counts['inactif'] ?></h2>
                     </div>
                     <i class="bi bi-people-fill display-4 opacity-50"></i>
                 </div>
                 <a href="/public/employees/view" class="text-white stretched-link"></a>
             </div>
           </div>
        </div>
        <div class="col-md-4">
           <div class="card text-white bg-info kpi-card">
             <div class="card-body">
                 <div class="d-flex justify-content-between align-items-center">
                     <div>
                         <h5 class="card-title">Masse salariale (<?= date('F Y') ?>)</h5>
                         <h2 class="mb-0"><?= number_format($total_salary, 2, ',', ' ') ?> €</h2>
                     </div>
                     <i class="bi bi-people-fill display-4 opacity-50"></i>
                 </div>
                 <a href="/public/payslips" class="text-white stretched-link"></a>
             </div>
           </div>
        </div>
    </div>

    <h3 class="mt-5">Évolution des salaires nets</h3>
    <canvas id="salaryChart" height="100"></canvas>

    <script>
        const ctx = document.getElementById('salaryChart').getContext('2d');
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: <?= json_encode(array_keys($stats)) ?>,
                datasets: [{
                    label: 'Salaires nets (€)',
                    data: <?= json_encode(array_values($stats)) ?>,
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 2,
                    fill: false
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: { beginAtZero: true }
                }
            }
        });
    </script>

    <h3 class="mt-5">Raccourcis</h3>
    <div class="row row-cols-1 row-cols-md-2 g-3">
        <div class="col">
            <a href="/employees/view" class="btn btn-outline-dark w-100">👥 Gérer les employés</a>
        </div>
        <div class="col">
            <a href="/payslips/create" class="btn btn-outline-primary w-100">📝 Nouvelle fiche de paie</a>
        </div>
        <!-- <div class="col">
            <a href="export_excel.php" class="btn btn-outline-success w-100">📤 Export Excel</a>
        </div>
        <div class="col">
            <a href="/alerts/index.php" class="btn btn-outline-danger w-100">🚨 Alertes RH</a>
        </div> -->
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
