<?php
namespace Controllers;

class ActivityLogController
{
    /**
     * Enregistre une activité dans les logs
     */
    public static function logActivity(string $action, string $description, ?int $userId = null): bool
    {
        try {
            // Exemple avec PDO
            $pdo = \Models\Database::getInstance();
            $stmt = $pdo->prepare(
                "INSERT INTO activity_logs 
                (user_id, action, description, created_at) 
                VALUES (:user_id, :action, :description, NOW())"
            );
            
            return $stmt->execute([
                ':user_id' => $userId,
                ':action' => $action,
                ':description' => $description
            ]);
            
        } catch (\PDOException $e) {
            error_log("Erreur de log d'activité: " . $e->getMessage());
            return false;
        }
    }

    /**
     * Récupère les logs d'activité
     */
    public function getLogs(int $limit = 100): array
    {
        $pdo = \Models\Database::getInstance();
        $stmt = $pdo->prepare("SELECT * FROM activity_logs ORDER BY id DESC LIMIT :limit");
        $stmt->bindValue(':limit', $limit, \PDO::PARAM_INT);
        $stmt->execute();
        
        return $stmt->fetchAll(\PDO::FETCH_ASSOC);
    }
}